unit Controls;

interface

uses
  System.IO,
  System.ComponentModel,
  System.Windows.Forms,
  System.Drawing,
  System.Drawing.Printing;

type
  { .NET to VCL mapping }

  // Controls:
  TApplication = System.Windows.Forms.Application;
  TControl     = System.Windows.Forms.Control;
  TForm        = System.Windows.Forms.Form;
  TButton      = System.Windows.Forms.Button;
  TLabel       = System.Windows.Forms.Label;
  TEdit        = System.Windows.Forms.TextBox;
  TListBox     = System.Windows.Forms.ListBox;

  TMainMenu    = System.Windows.Forms.MainMenu;
  TMenu        = System.Windows.Forms.Menu;
  TMenuItem    = System.Windows.Forms.MenuItem;

  // Dialogs:
  TPrintDialog        = System.Windows.Forms.PrintDialog;
  TPageSetupDialog    = System.Windows.Forms.PageSetupDialog;
  TPrintPreviewDialog = System.Windows.Forms.PrintPreviewDialog;
  TDialogResult       = System.Windows.Forms.DialogResult;
  TMessageBox         = System.Windows.Forms.MessageBox;

  // Event Handlers:
  TEventHandler = System.EventHandler;
  TEventArgs    = System.EventArgs;

  // Containers:
  TContainer    = System.ComponentModel.Container;

  // Graphics:
  TSize          = System.Drawing.Size;
  TPoint         = System.Drawing.Point;
  TFont          = System.Drawing.Font;
  TStringFormat  = System.Drawing.StringFormat;

  // Printing:
  TPrintDocument      = System.Drawing.Printing.PrintDocument;
  FStoredPageSettings = System.Drawing.Printing.PageSettings;
  TPrintEventArgs     = System.Drawing.Printing.PrintEventArgs;
  TPrintPageEventArgs = System.Drawing.Printing.PrintPageEventArgs;
  TPageSettings       = System.Drawing.Printing.PageSettings;

  // IO:
  TStreamReader  = System.IO.StreamReader;

implementation

end.
